import { useEffect, useRef, useState } from 'react';
import './App.css';
import "@resconet/jsbridge";
import { TextField } from '@mui/material';

function App() {
  const [name, setName] = useState("");
  const [label, setLabel] = useState("");
  const [labelColor, setLabelColor] = useState("black");
  const [backgroundColor, setBackgroundColor] = useState("white");
  const [inputColor, setInputColor] = useState("black");
  const appRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    MobileCRM.UI.EntityForm.requestObject(
      function (entityForm) {
        setName(entityForm.entity.primaryName);
        return true;
      },
      function (err) {
        MobileCRM.bridge.alert("An error occurred: " + err);
      },
      null
    );

    MobileCRM.Localization.initialize(
      (localization) => {
        setLabel(MobileCRM.Localization.get("account.name"));
      },
      (err) => MobileCRM.bridge.alert("An error occurred: " + err),
      null);

    MobileCRM.Application.getAppColor('FormBackground', function(color) {
      if(appRef.current) appRef.current.style.background = color;
    });
    MobileCRM.Application.getAppColor('FormItemLabelForeground', function(color) {
      if(appRef.current) setLabelColor(color);
    });
    MobileCRM.Application.getAppColor('FormItemBackground', function(color) {
      if(appRef.current) setBackgroundColor(color);
    });
    MobileCRM.Application.getAppColor('FormItemForeground', function(color) {
      if(appRef.current) setInputColor(color);
    });

    MobileCRM.UI.EntityForm.onChange(
        function (entityForm) {
          const changedItem = (entityForm.context as MobileCRM.UI.IFormChangeContext).changedItem;
          if (changedItem === "name") {
            setName(entityForm.entity.properties.name);
          }
        },
      true, null );
  }, [])

  return (
    <div className="App" ref={appRef}>
        <TextField
          id="outlined-basic"
          label={label}
          variant="outlined"
          value={name}
          onChange={(event: React.ChangeEvent<HTMLInputElement>) => {
            setName(event.target.value);
          }}
          onBlur={(event: React.FocusEvent<HTMLInputElement>) => {
            MobileCRM.UI.EntityForm.requestObject(
              function (entityForm) {
                entityForm.entity.properties.name=event.target.value;
                entityForm.isDirty = true;
                return true;
              },
              function (err) {
                MobileCRM.bridge.alert("An error occurred: " + err);
              },
              null
            );
          }}
          fullWidth type="text"
          size="small"
          style={{marginTop: '1em'}}
          InputLabelProps={{style: { color: labelColor }}}
          InputProps={{style: { background: backgroundColor, color: inputColor }}}
        />
    </div>
  );
}

export default App;
