## Integrating Custom iOS app with Citrix XenMobile

Citrix provides [MAM SDK](https://github.com/citrix/citrix-mam-sdks) implementing security features into apps. SDK isn’t part of our App Store app, but it can be incorporated into [Custom Mobile App](https://docs.resco.net/wiki/Custom_mobile_apps). Please make sure that you checked “Include Citrix MAM SDK” box before requesting new Custom app build. If you provided also valid distribution certificate and provisioning profile, resulting IPA installation should be suitable for side-loading onto your devices. Otherwise, you must resign IPA with your certificate and provisioning profile (see [Enterprise deployment on iOS](https://docs.resco.net/wiki/Enterprise_deployment_on_iOS)). 
However, Citrix EndPoint Management doesn’t support IPA installation and it requires wrapped MDX envelope.

To achieve it, you must pass following steps:

**Prerequisites**:
 - Mac OS 12.6 or later with Xcode 13+
 - Citrix MAMSDK_iOS.zip file from [GitHub releases](https://github.com/citrix/citrix-mam-sdks/releases)

**Steps**:
 - Request build of your Custom Mobile App via Woodford.
 - Your Resco account manager will contact you to discuss the pricing and to he approves the build.
 - Our branding portal will make the new IPA installation based on your Mobile App request and you will obtain a download link by email. Download IPA file.
 - If you haven’t provided distribution certificate and provisioning profile into Mobile Apps config, resign IPA file with you distribution certificate (see [Enterprise deployment on iOS](https://docs.resco.net/wiki/Enterprise_deployment_on_iOS)).
 - Unpack MAM SDK and copy MobileCrm.ipa file into SDK root folder.
 - Download [MDX generator](https://www.resco.net/downloads/CitrixMdxGenerator.zip) script and unpack it into the same folder.
 - Open Terminal app, go to MAM SDK root  folder (`command cd [folderpath]`) and place following command:

	`./generate_mdx MobileCrm.ipa`
 - Upload MobileCrm.mdx file into Citrix EndPoint Management and configure specific app details and policy settings that the Endpoint Management Store enforces.

